/* 
 * msgecli.c
 *
 * Моделює роботу клієнта, який передає запити серверу через чергу
 * повідомлень System V. Запити отримує від користувача. Відповіді
 * від сервера не отримує.
 * Ілюструє порядок застосування черг повідомлень System V.
 *
 */

#include "msge.h"

int main()
{
        struct msgbuf buf;      /* Буфер для повідомлення */
        /* Покажчик на поле даних повідомлення */
        struct mtext *mtext = (struct mtext *) buf.mtext;
        key_t msgkey;           /* Ключ черги повідомлень */
        int msgd;               /* Дескриптор черги повідомлень */
        pid_t pid;              /* Власний ідентифікатор */

        /* Визначає власний ідентифікатор. */
        pid = getpid();
        /* Генерує ключ черги повідомлень. */
        msgkey = ftok(PROJNAME, PROJNUM);
        if (msgkey == -1) {
                perror("ftok()");
                exit(EXIT_FAILURE);
        }
        /* Відкриває чергу повідомлень. */
        msgd = msgget(msgkey, 0);
        if (msgd == -1) {
                perror("msgget()");
                exit(EXIT_FAILURE);
        }

        do {
                /* Запитує від користувача слово. */
                printf("Request:  ");
                scanf("%s", mtext->text); 
                /* Формує та відправляє запит до сервера. */
                buf.mtype = SERVER_ID;
                mtext->sender_pid = pid;
                if (msgsnd(msgd, &buf, FULL_TEXT_SIZE, 0) < 0) {
                        perror("msgsnd()");
                        exit(EXIT_FAILURE);
                }
                mtext->text[0] = '\0';
                sleep(1);
                /* Запитує від користувача вказівку щодо продовження
                   роботи. */
                printf("Another request? [y/n] ");
                scanf("%s", mtext->text);
        } while (!(strcmp(mtext->text, "y") * strcmp(mtext->text, "Y")));

        exit(EXIT_SUCCESS);
}
